begin
plot=new(3,graphic)

in1=addfile("/home/sharedata/csr4/zhangyue/geo/H/H_0.05_10.nc","r")
pb1=in1->H
in2=addfile("/home/sharedata/csr4/zhangyue/geo/H/H_0.05_12.nc","r")
pb2=in2->H
;in3=addfile("/home/sharedata/csr4/zhangyue/geo/H/H_0.05_15.nc","r")
;pb3=in3->H

H1=new((/3600,7200/),float)

 do i =0,99
  do j=0,99
     H1(i,j)=H1@_FillValue
  end do
 end do

H1(100:3499,100:7099)=pb1(0:3399,0:6999)

 do p =3500,3599
  do q=7100,7199
     H1(p,q)=H1@_FillValue
  end do
 end do

H1!0="lat"
H1!1="lon"
H1&lat=fspan(-90,90,3600)
H1&lon=fspan(-180,180,7200)
H1&lat@units="degrees_north"
H1&lon@units="degrees_east"


;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
H2=new((/3600,7200/),float)

 do i =0,119
  do j=0,119
     H2(i,j)=H2@_FillValue
  end do
 end do

H2(120:3479,120:7079)=pb2(0:3359,0:6959)

 do p =3480,3599
  do q=7080,7199
     H2(p,q)=H2@_FillValue
  end do
 end do



H2!0="lat"
H2!1="lon"
H2&lat=fspan(-90,90,3600)
H2&lon=fspan(-180,180,7200)
H2&lat@units="degrees_north"
H2&lon@units="degrees_east"



 setvalues  NhlGetWorkspaceObjectId()
 "wsMaximumSize":1000000000
 end setvalues   

wks=gsn_open_wks("png","plot_h_3all_p")
gsn_define_colormap(wks,"BlueDarkRed18")

res=True
res@gsnDraw             = False           ; don't draw
res@gsnFrame            = False           ; don't advance frame
res@cnInfoLabelOn       = False           ; turn off cn info label
res@cnLinesOn=False;去掉等值线
res@gsnAddCyclic=False
res@cnLevelSelectionMode="ExplicitLevels";绘制特定等值线
res@cnLevels=(/0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.08,0.09,0.1,0.11,0.12,0.13,0.14,0.15,0.16,0.17,0.18,0.19,0.20,0.21,0.22,0.23,0.24,0.25,0.26,0.27,0.28,0.29,0.30,0.31,0.32,0.33,0.34,0.35,0.36,0.37,0.38,0.39,0.40,0.41,0.42,0.43,0.44,0.45,0.46,0.47,0.48,0.49,0.50,0.51,0.52,0.53,0.54,0.55,0.56,0.57,0.58,0.59,0.60,0.61,0.62,0.63,0.64,0.65,0.66,0.67,0.68,0.69,0.70,0.71,0.72,0.73,0.74,0.75,0.76,0.77,0.78,0.79,0.80,0.81,0.82,0.83,0.84,0.85,0.86,0.87,0.88,0.89,0.90,0.91,0.92,0.93,0.94,0.95,0.96,0.97,0.98,0.99,1.0/)
res@cnFillOn=True;颜色填充等值线
res@cnFillMode="RasterFill"
res@cnFillPalette="WhViBlGrYeOrRe";用该色板填色
resgsnSpreadColors=True;均匀选择颜色值
res@pmTickMarkDisplayMode="Always";坐标标签上添加符号度


res@mpCenterLonF=0;地图的中心经度
res@mpMaxLonF=180;地图的最东经度
res@mpMinLonF=-180;地图的最西经度
res@mpMaxLatF=60;地图的最北经度
res@mpMinLatF=-60;地图的最南经度
res@mpGeophysicalLineThicknessF =2.0

res@mpFillOn = True
res@mpOceanFillColor = "white"
res@mpInlandWaterFillColor = "white"
res@mpLandFillColor = "white"

res@gsnCenterString="";添加中间标题
res@gsnLeftString="";不绘制左标题
res@gsnRightString="";不绘制右标题
res@mpGridLatSpacingF=10;纬线间隔
res@mpGridLonSpacingF=10;经线间隔
res@pmLabelBarOrthogonalPosF=0.25;调整色标垂直方向的位置
  
res@tmXBLabelFontHeightF=0.025
res@tmYLLabelFontHeightF=0.025
res@tmBorderThicknessF=4
res@lbLabelFontHeightF=0.025
res@lbBoxSeparatorLinesOn=False
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
resd=True
resd@gsnDraw             = False           ; don't draw
resd@gsnFrame            = False           ; don't advance frame
resd@cnInfoLabelOn       = False           ; turn off cn info label
resd@cnLinesOn=False;去掉等值线
resd@gsnAddCyclic=False
resd@cnFillOn=True;颜色填充等值线
resd@cnFillMode="RasterFill"
;resd@cnFillPalette="";用该色板填色
resd@cnLevelSelectionMode="ExplicitLevels";绘制特定等值线
resd@cnLevels=(/-0.5,-0.3,-0.1,-0.05,-0.02,-0.01,0,0.01,0.02,0.05,0.1,0.3,0.5/)
;resd@cnFillColors=(/0,12,13,14,15,16,17,18,19/)
resd@pmTickMarkDisplayMode="Always";坐标标签上添加符号度

resd@mpCenterLonF=0  ;地图的中心经度
resd@mpMaxLonF=180   ;地图的最东经度
resd@mpMinLonF=-180  ;地图的最西经度
resd@mpMaxLatF=60    ;地图的最北经度
resd@mpMinLatF=-60   ;地图的最南经度
resd@mpGeophysicalLineThicknessF =2.0

resd@mpFillOn = True
resd@mpOceanFillColor = "white"
resd@mpInlandWaterFillColor = "white"
resd@mpLandFillColor = "white"

resd@tmXBLabelFontHeightF=0.025
resd@tmYLLabelFontHeightF=0.025
resd@tmBorderThicknessF=4
resd@lbLabelFontHeightF=0.025

resd@gsnCenterString="";添加中间标题
resd@gsnLeftString="";不绘制左标题
resd@gsnRightString="";不绘制右标题
resd@mpGridLatSpacingF=10;纬线间隔
resd@mpGridLonSpacingF=10;经线间隔
resd@pmLabelBarOrthogonalPosF=0.25;调整色标垂直方向的位置
resd@lbBoxSeparatorLinesOn=False
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
H3=H2-H1
printMinMax(H3,False)
copy_VarMeta(H2,H3)


plot(0)=gsn_csm_contour_map_ce(wks,H1,res)
plot(1)=gsn_csm_contour_map_ce(wks,H2,res)
plot(2)=gsn_csm_contour_map_ce(wks,H3,resd)

pres                  = True
pres@gsnMaximize=True
;pres@gsnPanelFigureStrings = (/"(a)","(b)"/)
pres@gsnPanelFigureStringsFontHeightF = 0.015
pres@amOrthogonalPosF    =-0.5
pres@amParallelPosF      =-0.5
pres@amJust = "TopLeft"
gsn_panel(wks,plot,(/3,1/),pres)

print("Game Over")
end

